//+------------------------------------------------------------------+
//|                                                 Wilder's DMI.mq4 |
//|                                                  coded by mladen |
//|                                                                  |
//| Directional movement index was developed by Welles Wilder        |
//+------------------------------------------------------------------+
#property copyright "mladen"
#property link      "www.forex-tsd,com"

#property indicator_separate_window
#property  indicator_buffers 7
#property indicator_color1   LimeGreen
#property indicator_color2   PaleVioletRed
#property indicator_color3   Green
#property indicator_color4   Tomato
#property indicator_color5   DimGray
#property indicator_color6   Orange
#property indicator_color7   DimGray
#property indicator_width5   2 
#property indicator_width6   2 
#property indicator_style7   STYLE_DOT

//
//
//
//
//

extern string TimeFrame       = "Current time frame";
extern int    DMILength       = 14;
extern bool   ShowADX         = true;
extern bool   ShowADXR        = false;
extern int    Level           = 20;
extern bool   alertsOn         = false;
extern bool   alertsOnCurrent  = true;
extern bool   alertsMessage    = true;
extern bool   alertsSound      = false;
extern bool   alertsNotify     = false;
extern bool   alertsEmail      = false;
extern string soundFile        = "alert2.wav";
extern bool   ShowArrows       = false;
extern string arrowsIdentifier = "DMI Arrows1";
extern double arrowsUpperGap   = 1.0;
extern double arrowsLowerGap   = 1.0;
extern color  arrowsUpColor    = LimeGreen;
extern color  arrowsDnColor    = Red;
extern int    arrowsUpCode     = 241;
extern int    arrowsDnCode     = 242;

//
//
//
//
//

double DIp[];
double DIm[];
double ADX[];
double ADXR[];
double ADXLevel[];
double dihp[];
double dihm[];
double trend[];

//
//
//
//
//

string indicatorFileName;
bool   calculateValue;
bool   returnBars;
int    timeFrame;

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//

int init()
{
   IndicatorBuffers(8);
   SetIndexBuffer(0,dihp);     SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(1,dihm);     SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(2,DIp);      SetIndexLabel(2,"DI+");
   SetIndexBuffer(3,DIm);      SetIndexLabel(3,"DI-");
   SetIndexBuffer(4,ADX);      SetIndexLabel(4,"ADX");
   SetIndexBuffer(5,ADXR);     SetIndexLabel(5,"ADXR");
   SetIndexBuffer(6,ADXLevel); SetIndexLabel(6,NULL);
   SetIndexBuffer(7,trend);
      for (int i=0;i<8;i++) SetIndexEmptyValue(i,0.00);
      
   //
   //
   //
   //
   //

      indicatorFileName = WindowExpertName();
      calculateValue    = (TimeFrame=="CalculateValue"); if (calculateValue) return(0);
      returnBars        = (TimeFrame=="returnBars");     if (returnBars)     return(0);
      timeFrame         = stringToTimeFrame(TimeFrame);

   //
   //
   //
   //
   //
   
   IndicatorShortName(timeFrameToString(timeFrame)+" Wilder\'s DMI ("+DMILength+")");
   return(0);
}

int deinit() 
{  
   deleteArrows(); 
return(0);
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

double work[][3];
#define _DIp 0
#define _DIm 1
#define _TR  2

int start()
{
   int i,r,counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
           int limit=MathMin(Bars-counted_bars,Bars-2);
           if (returnBars)  { dihp[0] = limit+1; return(0); }

   //
   //
   //
   //
   //
   
   if (calculateValue || timeFrame == Period())
   {
      if (ArrayRange(work,0)!=Bars) ArrayResize(work,Bars);
      double sf = (DMILength-1.0)/DMILength;
      for (i=limit, r=Bars-i-1;i>=0;i--,r++)
      {
         double currTR  = MathMax(High[i],Close[i+1])-MathMin(Low[i],Close[i+1]);
         double DeltaHi = High[i] - High[i+1];
	      double DeltaLo = Low[i+1] - Low[i];
         double plusDM  = 0.00;
         double minusDM = 0.00;
         
            if ((DeltaHi > DeltaLo) && (DeltaHi > 0)) plusDM  = DeltaHi;
            if ((DeltaLo > DeltaHi) && (DeltaLo > 0)) minusDM = DeltaLo;      
         
         //
         //
         //
         //
         //
         
            work[r][_DIp] = sf*work[r-1][_DIp] + plusDM;
            work[r][_DIm] = sf*work[r-1][_DIm] + minusDM;
            work[r][_TR]  = sf*work[r-1][_TR]  + currTR;
            ADXLevel[i]   = Level;

         //
         //
         //
         //
         //
                  
            DIp[i]  = 0;                   
            DIm[i]  = 0;                   
            dihp[i] = 0;
            dihp[i] = 0;
            if (work[r][_TR] > 0)
               {              
                  DIp[i] = 100.00 * work[r][_DIp]/work[r][_TR];
                  DIm[i] = 100.00 * work[r][_DIm]/work[r][_TR];
               }            
               if (DIp[i]>DIm[i]) dihp[i] = DIp[i]-DIm[i];
               if (DIp[i]<DIm[i]) dihm[i] = DIp[i]-DIm[i];
            if(ShowADX)
               {
                  double DX;
                  if((DIp[i] + DIm[i])>0) 
                       DX = 100*MathAbs(DIp[i] - DIm[i])/(DIp[i] + DIm[i]); 
                  else DX = 0.00;
                  ADX[i] = sf*ADX[i+1] + DX/DMILength; 
                  if(ShowADXR) ADXR[i] = 0.5*(ADX[i] + ADX[i+DMILength]);
               }
               
               trend[i] = trend[i+1];
               if (DIp[i] > DIm[i]) trend[i] = 1;
               if (DIp[i] < DIm[i]) trend[i] =-1;
               
               //
               //
               //
               //
               //
     
               if (ShowArrows)
               {
                 deleteArrow(Time[i]);
                 if (trend[i] != trend[i+1])
                 {
                   if (trend[i] == 1)  drawArrow(i,arrowsUpColor,arrowsUpCode,false);
                   if (trend[i] ==-1)  drawArrow(i,arrowsDnColor,arrowsDnCode, true);
                 }
               }
      }
      
      //
      //
      //
      //
      //
      
      if (alertsOn)
      {
         if (alertsOnCurrent)
              int whichBar = 0;
         else     whichBar = 1; 
         if (trend[whichBar] != trend[whichBar+1])
         if (trend[whichBar] == 1)
               doAlert("crossed up");
         else  doAlert("crossed down");       
   }        
      
      
   return(0);      
   }
      
   //
   //
   //
   //
   //
   
   limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrame,indicatorFileName,"returnBars",0,0)*timeFrame/Period()));
   for (i=limit;i>=0;i--)
   {
      int y = iBarShift(NULL,timeFrame,Time[i]);
         ADXLevel[i] = Level;
         dihp[i]  = iCustom(NULL,timeFrame,indicatorFileName,"CalculateValue",DMILength,ShowADX,ShowADXR,Level,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsNotify,alertsEmail,soundFile,ShowArrows,arrowsIdentifier,arrowsUpperGap,arrowsLowerGap,arrowsUpColor,arrowsDnColor,arrowsUpCode,arrowsDnCode,0,y);
         dihm[i]  = iCustom(NULL,timeFrame,indicatorFileName,"CalculateValue",DMILength,ShowADX,ShowADXR,Level,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsNotify,alertsEmail,soundFile,ShowArrows,arrowsIdentifier,arrowsUpperGap,arrowsLowerGap,arrowsUpColor,arrowsDnColor,arrowsUpCode,arrowsDnCode,1,y);
         DIp[i]   = iCustom(NULL,timeFrame,indicatorFileName,"CalculateValue",DMILength,ShowADX,ShowADXR,Level,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsNotify,alertsEmail,soundFile,ShowArrows,arrowsIdentifier,arrowsUpperGap,arrowsLowerGap,arrowsUpColor,arrowsDnColor,arrowsUpCode,arrowsDnCode,2,y);
         DIm[i]   = iCustom(NULL,timeFrame,indicatorFileName,"CalculateValue",DMILength,ShowADX,ShowADXR,Level,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsNotify,alertsEmail,soundFile,ShowArrows,arrowsIdentifier,arrowsUpperGap,arrowsLowerGap,arrowsUpColor,arrowsDnColor,arrowsUpCode,arrowsDnCode,3,y);
         if (ShowADX)  ADX[i]  = iCustom(NULL,timeFrame,indicatorFileName,"CalculateValue",DMILength,ShowADX,ShowADXR,Level,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsNotify,alertsEmail,soundFile,ShowArrows,arrowsIdentifier,arrowsUpperGap,arrowsLowerGap,arrowsUpColor,arrowsDnColor,arrowsUpCode,arrowsDnCode,4,y);
         if (ShowADXR) ADXR[i] = iCustom(NULL,timeFrame,indicatorFileName,"CalculateValue",DMILength,ShowADX,ShowADXR,Level,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsNotify,alertsEmail,soundFile,ShowArrows,arrowsIdentifier,arrowsUpperGap,arrowsLowerGap,arrowsUpColor,arrowsDnColor,arrowsUpCode,arrowsDnCode,5,y);
   } 
   return(0);
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

//
//
//
//
//

int stringToTimeFrame(string tfs)
{
   tfs = StringUpperCase(tfs);
   for (int i=ArraySize(iTfTable)-1; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[i],Period()));
                                                      return(Period());
}

//
//
//
//
//

string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//
//
//
//
//

string StringUpperCase(string str)
{
   string   s = str;

   for (int length=StringLen(str)-1; length>=0; length--)
   {
      int tchar = StringGetChar(s, length);
         if((tchar > 96 && tchar < 123) || (tchar > 223 && tchar < 256))
                     s = StringSetChar(s, length, tchar - 32);
         else if(tchar > -33 && tchar < 0)
                     s = StringSetChar(s, length, tchar + 224);
   }
   return(s);
} 

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

void doAlert(string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
      if (previousAlert != doWhat || previousTime != Time[0]) {
          previousAlert  = doWhat;
          previousTime   = Time[0];

          //
          //
          //
          //
          //

          message =  StringConcatenate(Symbol()," ",timeFrameToString(timeFrame)," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," Wilders DMI ",doWhat);
             if (alertsMessage) Alert(message);
             if (alertsNotify)  SendNotification(message);
             if (alertsEmail)   SendMail(StringConcatenate(Symbol()," Wilders DMI "),message);
             if (alertsSound)   PlaySound(soundFile);
      }
}

//
//
//
//
//

void drawArrow(int i,color theColor,int theCode,bool up)
{
   string name = arrowsIdentifier+":"+Time[i];
   double gap  = iATR(NULL,0,20,i);   
   
      //
      //
      //
      //
      //
      
      ObjectCreate(name,OBJ_ARROW,0,Time[i],0);
         ObjectSet(name,OBJPROP_ARROWCODE,theCode);
         ObjectSet(name,OBJPROP_COLOR,theColor);
         if (up)
               ObjectSet(name,OBJPROP_PRICE1,High[i] + arrowsUpperGap * gap);
         else  ObjectSet(name,OBJPROP_PRICE1,Low[i]  - arrowsLowerGap * gap);
}

//
//
//
//
//

void deleteArrows()
{
   string lookFor       = arrowsIdentifier+":";
   int    lookForLength = StringLen(lookFor);
   for (int i=ObjectsTotal()-1; i>=0; i--)
   {
      string objectName = ObjectName(i);
         if (StringSubstr(objectName,0,lookForLength) == lookFor) ObjectDelete(objectName);
   }
}

//
//
//
//
//

void deleteArrow(datetime time)
{
   string lookFor = arrowsIdentifier+":"+time; ObjectDelete(lookFor);
}



